/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.util.PortalLocalXYNormalized;
import qouteall.imm_ptl.peripheral.CommandStickItem;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;
import qouteall.imm_ptl.peripheral.wand.ProtoPortal;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;

public class PortalWandInteraction {
    private static final double SIZE_LIMIT = 64.0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final WeakHashMap<ServerPlayer, DraggingSession> draggingSessionMap = new WeakHashMap();
    private static final WeakHashMap<ServerPlayer, CopyingSession> copyingSessionMap = new WeakHashMap();

    private static void handleFinishPortalCreation(ServerPlayer player, ProtoPortal protoPortal) {
        Vec3 secondSideNormal;
        Vec3 firstSideNormal;
        Validate.isTrue((protoPortal.firstSide != null ? 1 : 0) != 0);
        Validate.isTrue((protoPortal.secondSide != null ? 1 : 0) != 0);
        Vec3 firstSideLeftBottom = protoPortal.firstSide.leftBottom;
        Vec3 firstSideRightBottom = protoPortal.firstSide.rightBottom;
        Vec3 firstSideLeftUp = protoPortal.firstSide.leftTop;
        Vec3 secondSideLeftBottom = protoPortal.secondSide.leftBottom;
        Vec3 secondSideRightBottom = protoPortal.secondSide.rightBottom;
        Vec3 secondSideLeftUp = protoPortal.secondSide.leftTop;
        Validate.notNull((Object)firstSideLeftBottom);
        Validate.notNull((Object)firstSideRightBottom);
        Validate.notNull((Object)firstSideLeftUp);
        Validate.notNull((Object)secondSideLeftBottom);
        Validate.notNull((Object)secondSideRightBottom);
        Validate.notNull((Object)secondSideLeftUp);
        ResourceKey<Level> firstSideDimension = protoPortal.firstSide.dimension;
        ResourceKey<Level> secondSideDimension = protoPortal.secondSide.dimension;
        Vec3 firstSideHorizontalAxis = firstSideRightBottom.m_82546_(firstSideLeftBottom);
        Vec3 firstSideVerticalAxis = firstSideLeftUp.m_82546_(firstSideLeftBottom);
        double firstSideWidth = firstSideHorizontalAxis.m_82553_();
        double firstSideHeight = firstSideVerticalAxis.m_82553_();
        Vec3 firstSideHorizontalUnitAxis = firstSideHorizontalAxis.m_82541_();
        Vec3 firstSideVerticalUnitAxis = firstSideVerticalAxis.m_82541_();
        if (Math.abs(firstSideWidth) < 0.001 || Math.abs(firstSideHeight) < 0.001) {
            player.m_213846_((Component)Component.m_237113_((String)"The first side is too small"));
            LOGGER.error("The first side is too small");
            return;
        }
        if (firstSideHorizontalUnitAxis.m_82526_(firstSideVerticalUnitAxis) > 0.001) {
            player.m_213846_((Component)Component.m_237113_((String)"The horizontal and vertical axis are not perpendicular in first side"));
            LOGGER.error("The horizontal and vertical axis are not perpendicular in first side");
            return;
        }
        if (firstSideWidth > 64.0 || firstSideHeight > 64.0) {
            player.m_213846_((Component)Component.m_237113_((String)"The first side is too large"));
            LOGGER.error("The first side is too large");
            return;
        }
        Vec3 secondSideHorizontalAxis = secondSideRightBottom.m_82546_(secondSideLeftBottom);
        Vec3 secondSideVerticalAxis = secondSideLeftUp.m_82546_(secondSideLeftBottom);
        double secondSideWidth = secondSideHorizontalAxis.m_82553_();
        double secondSideHeight = secondSideVerticalAxis.m_82553_();
        Vec3 secondSideHorizontalUnitAxis = secondSideHorizontalAxis.m_82541_();
        Vec3 secondSideVerticalUnitAxis = secondSideVerticalAxis.m_82541_();
        if (Math.abs(secondSideWidth) < 0.001 || Math.abs(secondSideHeight) < 0.001) {
            player.m_213846_((Component)Component.m_237113_((String)"The second side is too small"));
            LOGGER.error("The second side is too small");
            return;
        }
        if (secondSideHorizontalUnitAxis.m_82526_(secondSideVerticalUnitAxis) > 0.001) {
            player.m_213846_((Component)Component.m_237113_((String)"The horizontal and vertical axis are not perpendicular in second side"));
            LOGGER.error("The horizontal and vertical axis are not perpendicular in second side");
            return;
        }
        if (secondSideWidth > 64.0 || secondSideHeight > 64.0) {
            player.m_213846_((Component)Component.m_237113_((String)"The second side is too large"));
            LOGGER.error("The second side is too large");
            return;
        }
        if (Math.abs(firstSideHeight / firstSideWidth - secondSideHeight / secondSideWidth) > 0.001) {
            player.m_213846_((Component)Component.m_237113_((String)"The two sides have different aspect ratio"));
            LOGGER.error("The two sides have different aspect ratio");
            return;
        }
        boolean overlaps = false;
        if (firstSideDimension == secondSideDimension && Math.abs((firstSideNormal = firstSideHorizontalUnitAxis.m_82537_(firstSideVerticalUnitAxis)).m_82526_(secondSideNormal = secondSideHorizontalUnitAxis.m_82537_(secondSideVerticalUnitAxis))) > 0.99 && Math.abs(firstSideLeftBottom.m_82546_(secondSideLeftBottom).m_82526_(firstSideNormal)) < 0.001) {
            Vec3 coordCenter = firstSideLeftBottom;
            Vec3 coordX = firstSideHorizontalAxis;
            Vec3 coordY = firstSideVerticalAxis;
            Range firstSideXRange = Range.createUnordered(firstSideLeftBottom.m_82546_(coordCenter).m_82526_(coordX), firstSideRightBottom.m_82546_(coordCenter).m_82526_(coordX));
            Range firstSideYRange = Range.createUnordered(firstSideLeftBottom.m_82546_(coordCenter).m_82526_(coordY), firstSideLeftUp.m_82546_(coordCenter).m_82526_(coordY));
            Range secondSideXRange = Range.createUnordered(secondSideLeftBottom.m_82546_(coordCenter).m_82526_(coordX), secondSideRightBottom.m_82546_(coordCenter).m_82526_(coordX));
            Range secondSideYRange = Range.createUnordered(secondSideLeftBottom.m_82546_(coordCenter).m_82526_(coordY), secondSideLeftUp.m_82546_(coordCenter).m_82526_(coordY));
            if (firstSideXRange.intersect(secondSideXRange) != null && firstSideYRange.intersect(secondSideYRange) != null) {
                overlaps = true;
            }
        }
        Portal portal = (Portal)((EntityType)IPRegistry.PORTAL.get()).m_20615_((Level)McHelper.getServerWorld(firstSideDimension));
        Validate.notNull((Object)portal);
        portal.setOriginPos(firstSideLeftBottom.m_82549_(firstSideHorizontalAxis.m_82490_(0.5)).m_82549_(firstSideVerticalAxis.m_82490_(0.5)));
        portal.width = firstSideWidth;
        portal.height = firstSideHeight;
        portal.axisW = firstSideHorizontalUnitAxis;
        portal.axisH = firstSideVerticalUnitAxis;
        portal.dimensionTo = secondSideDimension;
        portal.setDestination(secondSideLeftBottom.m_82549_(secondSideHorizontalAxis.m_82490_(0.5)).m_82549_(secondSideVerticalAxis.m_82490_(0.5)));
        portal.scaling = secondSideWidth / firstSideWidth;
        DQuaternion secondSideOrientation = DQuaternion.matrixToQuaternion(secondSideHorizontalUnitAxis, secondSideVerticalUnitAxis, secondSideHorizontalUnitAxis.m_82537_(secondSideVerticalUnitAxis));
        portal.setOtherSideOrientation(secondSideOrientation);
        Object flippedPortal = PortalManipulation.createFlippedPortal(portal, (EntityType)IPRegistry.PORTAL.get());
        Object reversePortal = PortalManipulation.createReversePortal(portal, (EntityType)IPRegistry.PORTAL.get());
        Object parallelPortal = PortalManipulation.createFlippedPortal(reversePortal, (EntityType)IPRegistry.PORTAL.get());
        McHelper.spawnServerEntity(portal);
        if (overlaps) {
            player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.overlap"));
        } else {
            McHelper.spawnServerEntity(flippedPortal);
            McHelper.spawnServerEntity(reversePortal);
            McHelper.spawnServerEntity(parallelPortal);
        }
        player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.finished"));
        PortalWandInteraction.giveCommandStick(player, "/portal eradicate_portal_cluster");
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(() -> {
            draggingSessionMap.entrySet().removeIf(e -> {
                ServerPlayer player = (ServerPlayer)e.getKey();
                if (player.m_213877_()) {
                    return true;
                }
                return player.m_21205_().m_41720_() != PeripheralModEntry.PORTAL_WAND.get();
            });
            copyingSessionMap.entrySet().removeIf(e -> {
                ServerPlayer player = (ServerPlayer)e.getKey();
                return player.m_213877_();
            });
        });
        IPGlobal.serverCleanupSignal.connect(draggingSessionMap::clear);
        IPGlobal.serverCleanupSignal.connect(copyingSessionMap::clear);
    }

    @Nullable
    public static UnilateralPortalState applyDrag(UnilateralPortalState originalState, Vec3 cursorPos, DraggingInfo info, boolean updateInternalState) {
        if (info.lockedAnchor == null) {
            Vec3 offset = info.draggingAnchor.getOffset(originalState);
            Vec3 newPos = cursorPos.m_82546_(offset);
            return new UnilateralPortalState.Builder().from(originalState).position(newPos).build();
        }
        OneLockDraggingResult r = PortalWandInteraction.performDragWithOneLockedAnchor(originalState, info.lockedAnchor, info.draggingAnchor, cursorPos, info.previousRotationAxis, info.lockWidth, info.lockHeight);
        if (r == null) {
            return null;
        }
        if (updateInternalState) {
            info.previousRotationAxis = r.rotationAxis();
        }
        return r.newState();
    }

    private static void handleFinishDrag(ServerPlayer player) {
        DraggingSession session = draggingSessionMap.remove(player);
        if (session == null) {
            return;
        }
        Portal portal = session.getPortal();
        if (portal != null) {
            portal.reloadAndSyncToClientNextTick();
        }
    }

    private static void handleUndoDrag(ServerPlayer player) {
        DraggingSession session = draggingSessionMap.get(player);
        if (session == null) {
            return;
        }
        Portal portal = session.getPortal();
        if (portal == null) {
            LOGGER.error("Cannot find portal {}", (Object)session.portalId);
            return;
        }
        portal.setPortalState(session.originalState);
        portal.reloadAndSyncToClientNextTick();
        portal.rectifyClusterPortals(true);
        draggingSessionMap.remove(player);
    }

    private static void handleDraggingRequest(ServerPlayer player, UUID portalId, Vec3 cursorPos, DraggingInfo draggingInfo, Portal portal) {
        DraggingSession session = draggingSessionMap.get(player);
        if (session == null || !session.portalId.equals(portalId)) {
            session = new DraggingSession((ResourceKey<Level>)player.m_9236_().m_46472_(), portalId, portal.getPortalState(), draggingInfo);
            draggingSessionMap.put(player, session);
        }
        UnilateralPortalState newThisSideState = PortalWandInteraction.applyDrag(session.originalState.getThisSideState(), cursorPos, draggingInfo, true);
        if (PortalWandInteraction.validateDraggedPortalState(session.originalState, newThisSideState, (Player)player)) {
            portal.setThisSideState(newThisSideState, draggingInfo.shouldLockScale());
            portal.reloadAndSyncToClientNextTick();
            portal.rectifyClusterPortals(true);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Invalid dragging"));
        }
    }

    private static boolean checkPermission(ServerPlayer player) {
        if (!PortalWandInteraction.canPlayerUsePortalWand(player)) {
            player.m_213846_((Component)Component.m_237113_((String)"You cannot use portal wand"));
            LOGGER.error("Player cannot use portal wand {}", (Object)player);
            return false;
        }
        return true;
    }

    public static boolean validateDraggedPortalState(PortalState originalState, UnilateralPortalState newThisSideState, Player player) {
        if (newThisSideState == null) {
            return false;
        }
        if (newThisSideState.width() > 64.1) {
            return false;
        }
        if (newThisSideState.height() > 64.1) {
            return false;
        }
        if (newThisSideState.width() < 0.05) {
            return false;
        }
        if (newThisSideState.height() < 0.05) {
            return false;
        }
        if (originalState.fromWorld != newThisSideState.dimension()) {
            return false;
        }
        return !(newThisSideState.position().m_82554_(player.m_20182_()) > 64.0);
    }

    private static boolean canPlayerUsePortalWand(ServerPlayer player) {
        return player.m_20310_(2) || IPGlobal.easeCreativePermission && player.m_7500_();
    }

    private static void giveCommandStick(ServerPlayer player, String command) {
        CommandStickItem.Data data = null;
        if (data == null) {
            data = new CommandStickItem.Data(command, command, List.of(), false);
        }
        ItemStack stack = new ItemStack((ItemLike)PeripheralModEntry.COMMAND_STICK_ITEM.get());
        stack.m_41751_(data.toTag());
        if (!player.m_150109_().m_36063_(stack)) {
            player.m_150109_().m_36054_(stack);
        }
    }

    public static boolean isDragging(ServerPlayer player) {
        return draggingSessionMap.containsKey(player);
    }

    @Nullable
    public static OneLockDraggingResult performDragWithOneLockedAnchor(UnilateralPortalState originalState, PortalLocalXYNormalized lockedLocalPos, PortalLocalXYNormalized draggingLocalPos, Vec3 draggedPos, @Nullable Vec3 previousRotationAxis, boolean lockWidth, boolean lockHeight) {
        double newHeight;
        double newWidth;
        DQuaternion rotation;
        Vec3 newOffsetN;
        Vec3 draggedPosOriginalPos = draggingLocalPos.getPos(originalState);
        Vec3 lockedPos = lockedLocalPos.getPos(originalState);
        Vec3 originalOffset = draggedPosOriginalPos.m_82546_(lockedPos);
        Vec3 newOffset = draggedPos.m_82546_(lockedPos);
        double newOffsetLen = newOffset.m_82553_();
        double originalOffsetLen = originalOffset.m_82553_();
        if (newOffsetLen < 1.0E-5 || originalOffsetLen < 1.0E-5) {
            return null;
        }
        Vec3 originalOffsetN = originalOffset.m_82541_();
        double dot = originalOffsetN.m_82526_(newOffsetN = newOffset.m_82541_());
        if (Math.abs(dot) < 0.99999) {
            rotation = DQuaternion.getRotationBetween(originalOffset, newOffset).fixFloatingPointErrorAccumulation();
        } else if (dot > 0.0) {
            rotation = DQuaternion.identity;
        } else {
            Plane planeOfPossibleAxis = new Plane(Vec3.f_82478_, originalOffsetN);
            if (previousRotationAxis != null) {
                Vec3 projected = planeOfPossibleAxis.getProjection(previousRotationAxis);
                if (projected.m_82556_() < 1.0E-5) {
                    return null;
                }
                Vec3 axis = projected.m_82541_();
                rotation = DQuaternion.rotationByDegrees(axis, 180.0).fixFloatingPointErrorAccumulation();
            } else {
                rotation = DQuaternion.identity;
            }
        }
        DQuaternion newOrientation = rotation.hamiltonProduct(originalState.orientation()).fixFloatingPointErrorAccumulation();
        PortalLocalXYNormalized deltaLocalXY = draggingLocalPos.subtract(lockedLocalPos);
        if (lockWidth && lockHeight) {
            newWidth = originalState.width();
            newHeight = originalState.height();
        } else {
            Vec3 newNormal = rotation.rotate(originalState.getNormal());
            if (lockWidth) {
                assert (!lockHeight);
                newWidth = originalState.width();
                if (Math.abs(deltaLocalXY.ny()) < 0.001) {
                    newHeight = originalState.height();
                } else {
                    double subWidth = Math.abs(deltaLocalXY.nx()) * newWidth;
                    double diff = newOffsetLen * newOffsetLen - subWidth * subWidth;
                    if (diff < 1.0E-6) {
                        return null;
                    }
                    double subHeight = Math.sqrt(diff);
                    newHeight = subHeight / Math.abs(deltaLocalXY.ny());
                    if (Math.abs(subWidth) > 0.001) {
                        newOrientation = PortalWandInteraction.getOrientationByNormalDiagonalWidthHeight(newNormal, newOffset, subWidth, subHeight, Math.signum(deltaLocalXY.nx()), Math.signum(deltaLocalXY.ny()));
                    }
                }
            } else if (lockHeight) {
                assert (!lockWidth);
                newHeight = originalState.height();
                if (Math.abs(deltaLocalXY.nx()) < 0.001) {
                    newWidth = originalState.width();
                } else {
                    double subHeight = Math.abs(deltaLocalXY.ny()) * newHeight;
                    double diff = newOffsetLen * newOffsetLen - subHeight * subHeight;
                    if (diff < 1.0E-6) {
                        return null;
                    }
                    double subWidth = Math.sqrt(diff);
                    newWidth = subWidth / Math.abs(deltaLocalXY.nx());
                    if (Math.abs(subHeight) > 0.001) {
                        newOrientation = PortalWandInteraction.getOrientationByNormalDiagonalWidthHeight(newNormal, newOffset, subWidth, subHeight, Math.signum(deltaLocalXY.nx()), Math.signum(deltaLocalXY.ny()));
                    }
                }
            } else {
                double scaling = newOffsetLen / originalOffsetLen;
                newWidth = originalState.width() * scaling;
                newHeight = originalState.height() * scaling;
            }
        }
        Vec3 newLockedPosOffset = newOrientation.rotate(new Vec3((lockedLocalPos.nx() - 0.5) * newWidth, (lockedLocalPos.ny() - 0.5) * newHeight, 0.0));
        Vec3 newOrigin = lockedPos.m_82546_(newLockedPosOffset);
        UnilateralPortalState newPortalState = new UnilateralPortalState(originalState.dimension(), newOrigin, newOrientation, newWidth, newHeight);
        return new OneLockDraggingResult(newPortalState, rotation.getRotatingAxis());
    }

    private static DQuaternion getOrientationByNormalDiagonalWidthHeight(Vec3 normal, Vec3 diagonal, double width, double height, double sigX, double sigY) {
        Vec3 newOffsetN = diagonal.m_82541_();
        double newOffsetLen = diagonal.m_82553_();
        Vec3 sideVecN = normal.m_82537_(newOffsetN).m_82541_();
        double sideVecLen = width * height / newOffsetLen;
        double wFront = sideVecLen * width / height;
        double hFront = sideVecLen * height / width;
        Vec3 sideVecW = sideVecN.m_82490_(-sideVecLen * sigX * sigY);
        Vec3 sideVecH = sideVecW.m_82490_(-1.0);
        Vec3 newAxisW = newOffsetN.m_82490_(wFront).m_82549_(sideVecW).m_82541_().m_82490_(sigX);
        Vec3 newAxisH = newOffsetN.m_82490_(hFront).m_82549_(sideVecH).m_82541_().m_82490_(sigY);
        DQuaternion newOrientation = DQuaternion.fromFacingVecs(newAxisW, newAxisH).fixFloatingPointErrorAccumulation();
        return newOrientation;
    }

    public static void handleCopyCutPortal(ServerPlayer player, UUID portalId, boolean isCut) {
        Portal portal = WandUtil.getPortalByUUID(player.m_9236_(), portalId);
        if (portal == null) {
            player.m_213846_((Component)Component.m_237113_((String)("Cannot find portal " + String.valueOf(portalId))));
            return;
        }
        PortalState portalState = portal.getPortalState();
        CompoundTag portalData = portal.writePortalDataToNbt();
        Portal flipped = null;
        Portal reverse = null;
        Portal parallel = null;
        PortalExtension ext = PortalExtension.get(portal);
        if (ext.flippedPortal != null) {
            flipped = ext.flippedPortal;
        }
        if (ext.reversePortal != null) {
            reverse = ext.reversePortal;
        }
        if (ext.parallelPortal != null) {
            parallel = ext.parallelPortal;
        }
        CopyingSession copyingSession = new CopyingSession(portalState, portalData, isCut, flipped != null, reverse != null, parallel != null);
        copyingSessionMap.put(player, copyingSession);
        if (isCut) {
            portal.m_142687_(Entity.RemovalReason.KILLED);
            if (flipped != null) {
                flipped.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (reverse != null) {
                reverse.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (parallel != null) {
                parallel.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    private static void handleConfirmCopyCut(ServerPlayer player, Vec3 origin, DQuaternion rawOrientation) {
        CopyingSession copyingSession = copyingSessionMap.remove(player);
        if (copyingSession == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Missing copying session"));
            return;
        }
        DQuaternion orientation = rawOrientation.fixFloatingPointErrorAccumulation();
        if (player.m_20182_().m_82557_(origin) > 4096.0) {
            player.m_213846_((Component)Component.m_237113_((String)"Too far away from the portal"));
            return;
        }
        Portal portal = (Portal)((EntityType)IPRegistry.PORTAL.get()).m_20615_(player.m_9236_());
        assert (portal != null);
        portal.readPortalDataFromNbt(copyingSession.portalData);
        PortalState originalPortalState = copyingSession.portalState;
        UnilateralPortalState originalThisSide = originalPortalState.getThisSideState();
        UnilateralPortalState originalOtherSide = originalPortalState.getOtherSideState();
        UnilateralPortalState newThisSide = new UnilateralPortalState((ResourceKey<Level>)player.m_9236_().m_46472_(), origin, orientation, originalThisSide.width(), originalThisSide.height());
        portal.setPortalState(UnilateralPortalState.combine(newThisSide, originalOtherSide));
        portal.resetAnimationReferenceState(true, false);
        if (copyingSession.isCut()) {
            McHelper.spawnServerEntity(portal);
            if (copyingSession.hasFlipped) {
                Object flippedPortal = PortalManipulation.createFlippedPortal(portal, (EntityType)IPRegistry.PORTAL.get());
                ((Portal)flippedPortal).resetAnimationReferenceState(true, false);
                McHelper.spawnServerEntity(flippedPortal);
            }
            if (copyingSession.hasReverse) {
                Object reversePortal = PortalManipulation.createReversePortal(portal, (EntityType)IPRegistry.PORTAL.get());
                ((Portal)reversePortal).resetAnimationReferenceState(false, true);
                McHelper.spawnServerEntity(reversePortal);
                if (copyingSession.hasParallel) {
                    Object parallelPortal = PortalManipulation.createFlippedPortal(reversePortal, (EntityType)IPRegistry.PORTAL.get());
                    ((Portal)parallelPortal).resetAnimationReferenceState(false, true);
                    McHelper.spawnServerEntity(parallelPortal);
                }
            }
        } else {
            PortalExtension.get((Portal)portal).bindCluster = false;
            McHelper.spawnServerEntity(portal);
            if (copyingSession.hasFlipped || copyingSession.hasReverse || copyingSession.hasParallel) {
                player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.copy.not_copying_cluster"));
                PortalWandInteraction.giveCommandStick(player, "/portal complete_bi_way_bi_faced_portal");
            }
        }
    }

    private static void handleClearPortalClipboard(ServerPlayer player) {
        copyingSessionMap.remove(player);
    }

    public static final class DraggingInfo {
        @Nullable
        public final PortalLocalXYNormalized lockedAnchor;
        public final PortalLocalXYNormalized draggingAnchor;
        @Nullable
        public Vec3 previousRotationAxis;
        public final boolean lockWidth;
        public final boolean lockHeight;

        public DraggingInfo(@Nullable PortalLocalXYNormalized lockedAnchor, PortalLocalXYNormalized draggingAnchor, @Nullable Vec3 previousRotationAxis, boolean lockWidth, boolean lockHeight) {
            this.lockedAnchor = lockedAnchor;
            this.draggingAnchor = draggingAnchor;
            this.previousRotationAxis = previousRotationAxis;
            this.lockWidth = lockWidth;
            this.lockHeight = lockHeight;
        }

        public boolean shouldLockScale() {
            return this.lockWidth || this.lockHeight;
        }

        public boolean isValid() {
            if (this.lockedAnchor != null && !this.lockedAnchor.isValid()) {
                return false;
            }
            return this.draggingAnchor.isValid();
        }
    }

    public record OneLockDraggingResult(UnilateralPortalState newState, Vec3 rotationAxis) {
    }

    private static class DraggingSession {
        private final ResourceKey<Level> dimension;
        private final UUID portalId;
        private final PortalState originalState;
        private final DraggingInfo lastDraggingInfo;

        public DraggingSession(ResourceKey<Level> dimension, UUID portalId, PortalState originalState, DraggingInfo lastDraggingInfo) {
            this.dimension = dimension;
            this.portalId = portalId;
            this.originalState = originalState;
            this.lastDraggingInfo = lastDraggingInfo;
        }

        @Nullable
        public Portal getPortal() {
            Entity entity = McHelper.getServerWorld(this.dimension).m_8791_(this.portalId);
            if (entity instanceof Portal) {
                return (Portal)entity;
            }
            return null;
        }
    }

    private record CopyingSession(PortalState portalState, CompoundTag portalData, boolean isCut, boolean hasFlipped, boolean hasReverse, boolean hasParallel) {
    }

    public static class RemoteCallables {
        public static void finishPortalCreation(ServerPlayer player, ProtoPortal protoPortal) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleFinishPortalCreation(player, protoPortal);
        }

        public static void requestApplyDrag(ServerPlayer player, UUID portalId, Vec3 cursorPos, DraggingInfo draggingInfo) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            Entity entity = ((ServerLevel)player.m_9236_()).m_8791_(portalId);
            if (!(entity instanceof Portal)) {
                LOGGER.error("Cannot find portal {}", (Object)portalId);
                return;
            }
            Portal portal = (Portal)entity;
            if (!draggingInfo.isValid()) {
                player.m_213846_((Component)Component.m_237113_((String)"Invalid dragging info"));
                LOGGER.error("Invalid dragging info {}", (Object)draggingInfo);
                return;
            }
            PortalWandInteraction.handleDraggingRequest(player, portalId, cursorPos, draggingInfo, portal);
        }

        public static void undoDrag(ServerPlayer player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleUndoDrag(player);
        }

        public static void finishDragging(ServerPlayer player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleFinishDrag(player);
        }

        public static void copyCutPortal(ServerPlayer player, UUID portalId, boolean isCut) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleCopyCutPortal(player, portalId, isCut);
        }

        public static void confirmCopyCut(ServerPlayer player, Vec3 origin, DQuaternion orientation) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleConfirmCopyCut(player, origin, orientation);
        }

        public static void clearPortalClipboard(ServerPlayer player) {
            if (!PortalWandInteraction.checkPermission(player)) {
                return;
            }
            PortalWandInteraction.handleClearPortalClipboard(player);
        }
    }
}

